
<?php $__env->startSection('content'); ?>
<!-- Header start -->
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Header end --> 
<!-- Inner Page Title start -->
<?php echo $__env->make('includes.inner_page_title', ['page_title'=>__('Favourite Jobs')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Inner Page Title end -->
<div class="listpgWraper">
    <div class="container">
        <div class="row">
            <?php echo $__env->make('includes.user_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="col-md-9 col-sm-8"> 
                <div class="myads">
                <ul class="featuredlist row">
                        <!-- job start --> 
                        <?php if(isset($jobs) && count($jobs)): ?>
                        <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $company = $job->getCompany(); ?>
                        <?php if(null !== $company): ?>
                      


                        <li class="col-lg-6 col-md-6">
                            <div class="jobint mt-0 mb-4">

                                <div class="d-flex">
                                    <div class="fticon"><i class="fas fa-briefcase"></i> <?php echo e($job->getJobType('job_type')); ?></div>                        
                                </div>
                                <h4><a href="<?php echo e(route('job.detail', [$job->slug])); ?>" title="<?php echo e($job->title); ?>"><?php echo \Illuminate\Support\Str::limit($job->title, $limit = 20, $end = '...'); ?></a>
                                </h4>
                                <?php if(!(bool)$job->hide_salary): ?>                    
                                <div class="salary mb-2">Salary: <strong><?php echo e($job->salary_currency.''.$job->salary_from); ?> - <?php echo e($job->salary_currency.''.$job->salary_to); ?>/<?php echo e($job->getSalaryPeriod('salary_period')); ?></strong></div>
                                <?php endif; ?> 
                                <strong><i class="fas fa-map-marker-alt"></i> <?php echo e($job->getCity('city')); ?></strong>                     
                                <div class="jobcompany">
                                <div class="ftjobcomp">
                                    <span><?php echo e($job->created_at->format('M d, Y')); ?></span>
                                    <a href="<?php echo e(route('company.detail', $company->slug)); ?>" title="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></a>
                                </div>
                                <a href="<?php echo e(route('company.detail', $company->slug)); ?>" class="company-logo" title="<?php echo e($company->name); ?>"><?php echo e($company->printCompanyImage()); ?> </a>
                                </div>

                                <?php if(Auth::check() && Auth::user()->isFavouriteJob($job->slug)): ?>
                                <a href="<?php echo e(route('remove.from.favourite', $job->slug)); ?>" class="btn btn-danger mt-3"><i class="fas fa-times"></i> <?php echo e(__('Remove')); ?></a>                                
                                <?php endif; ?>


                            </div>
                        </li>



                        <!-- job end --> 
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            
                            <div class="nodatabox">
                                <h4><?php echo e(__('No Favourite Jobs Found')); ?></h4>
                                <div class="viewallbtn mt-2"><a href="<?php echo e(url('/jobs')); ?>"><?php echo e(__('Search Jobs')); ?></a></div>
                            </div>


                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<?php echo $__env->make('includes.immediate_available_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jobsportal\resources\views/job/my_favourite_jobs.blade.php ENDPATH**/ ?>